int dock = 0;   //Indicates that sound is coming from the dock
int aux = 1;    //Indicates that sound is coming from the external input

int vol1 = 2;   //Indicate volume level 1
int vol2 = 3;   //Indicate volume level 2
int vol3 = 4;   //Indicate volume level 3
int vol4 = 5;   //Indicate volume level 4

void setup() {                
  Serial.begin(9600);          //  setup serial for debugging
  
  // initialize the digital pins 0-5 as an output.
  pinMode(0, OUTPUT);     
  pinMode(1, OUTPUT);     
  pinMode(2, OUTPUT);     
  pinMode(3, OUTPUT);     
  pinMode(4, OUTPUT);     
  pinMode(5, OUTPUT);  

  // Startup-sequence to check that all LEDs are working
  digitalWrite(0, HIGH);   // turn the LED on (HIGH is the voltage level)
  digitalWrite(1, HIGH);   // turn the LED on (HIGH is the voltage level)
  digitalWrite(2, HIGH);   // turn the LED on (HIGH is the voltage level)
  digitalWrite(3, HIGH);   // turn the LED on (HIGH is the voltage level)
  digitalWrite(4, HIGH);   // turn the LED on (HIGH is the voltage level)
  digitalWrite(5, HIGH);   // turn the LED on (HIGH is the voltage level)
  delay(1000);               // wait for a second
  
  // Turn off all LEDs
  digitalWrite(0, LOW);
  digitalWrite(1, LOW);
  digitalWrite(2, LOW);
  digitalWrite(3, LOW);
  digitalWrite(4, LOW);
  digitalWrite(5, LOW);
  delay(1000);               // wait for a second
  
  //Turn on "dock" LED
  digitalWrite(dock, HIGH);
}



void loop() {
  int sensorValue = analogRead(0);                  //Read analog input value
  float voltage = sensorValue * (3.3 / 1024.0);     //Convert to voltage level
  Serial.println(voltage);                          //Print voltage level for debugging
  
  
  // Turn on the volume LEDs according to the input value
  if (voltage < 0.01) {
      digitalWrite(vol1, HIGH);
      digitalWrite(vol2, LOW);
      digitalWrite(vol3, LOW);
      digitalWrite(vol4, LOW);
  }
  if (voltage > 0.01 && voltage < 0.03) {
      digitalWrite(vol1, HIGH);
      digitalWrite(vol2, HIGH);
      digitalWrite(vol3, LOW);
      digitalWrite(vol4, LOW);
  }  
  if (voltage > 0.03 && voltage < 0.05) {
      digitalWrite(vol1, HIGH);
      digitalWrite(vol2, HIGH);
      digitalWrite(vol3, HIGH);
      digitalWrite(vol4, LOW);
  }
  if (voltage > 0.05) {
      digitalWrite(vol1, HIGH);
      digitalWrite(vol2, HIGH);
      digitalWrite(vol3, HIGH);
      digitalWrite(vol4, HIGH);
  }
}




